/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/

#ifndef _SURFACESETIPACCEPTANCECOMMAND_H_
#define _SURFACESETIPACCEPTANCECOMMAND_H_

#include <stdlib.h>
#include <string.h>
#include "ilm_types.h"
#include "ICommand.h"
#include "Log.h"

class SurfaceSetIpAcceptanceCommand : public ICommand
{
public:
  SurfaceSetIpAcceptanceCommand(pid_t sender, const unsigned int givenid, t_ilm_string *pSeats, const unsigned int num_seats)
    : ICommand(ExecuteSynchronous, sender)
    , m_idtoSet(givenid)
    {
        m_pSeatArray = NULL;
        m_sizeSeatArray = 0;
        unsigned int seatCount = 0;
        if ((NULL != pSeats) && (0 != num_seats))
        {
            m_pSeatArray = (char**)malloc((sizeof(char*)) * num_seats);
            if (NULL != m_pSeatArray)
            {
                for (seatCount = 0; seatCount < num_seats; seatCount++)
                {
                    if (NULL != pSeats[seatCount])
                    {
                        m_pSeatArray[seatCount] = strdup(pSeats[seatCount]);
                        if (NULL == m_pSeatArray[seatCount])
                        {
                            LOG_ERROR("SurfaceSetInputAcceptanceOnCommand", "Unable to allocate memory");
                            break;
                        }
                    }
                }
            }
            else
            {
                LOG_ERROR("SurfaceSetInputAcceptanceOnCommand", "Unable to allocate memory");
            }
            m_sizeSeatArray = seatCount;
        }
    }

    /**
     * \brief default destructor
     */
    virtual ~SurfaceSetIpAcceptanceCommand()
    {
        unsigned int seatCount = 0;
        if (NULL != m_pSeatArray)
        {
            for (seatCount = 0; seatCount < m_sizeSeatArray; seatCount++)
            {
                free(m_pSeatArray[seatCount]);
            }
            free(m_pSeatArray);
        }
    }

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManagement COmmands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionSuccessRedraw: execution successful and screen needs to be redrawn
     * \return ExecutionFailed: execution failed
     * \return ExecutionFailedRedraw: execution unsuccessful and screen needs to be redrawn
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    const unsigned int m_idtoSet;
    char **m_pSeatArray;
    unsigned int m_sizeSeatArray;
};

#endif /* _SURFACESETIPACCEPTANCECOMMAND_H_ */
